CREATE FUNCTION [dbo].[NumerFaktury_Indeks]
(
    @cFaktura NVARCHAR(30),
    @cFormat NVARCHAR(30),
    @nPreferowanaNumeracja INT
)
RETURNS NVARCHAR(30)
AS 
BEGIN

    DECLARE @cIndeks NVARCHAR(30);
    DECLARE @cRok NVARCHAR(30);
    DECLARE @cMiesiac NVARCHAR(30);
    DECLARE @cNumer NVARCHAR(30);

    IF LTrim(@cFaktura) = ''
    BEGIN
        RETURN '00000000000';
    END;

    SET @cRok = [dbo].[NumerFaktury_Wyodrebnij](@cFaktura, 'R', @cFormat);
    
    IF @nPreferowanaNumeracja = 0
        SET @cMiesiac = '0'
    ELSE
        SET @cMiesiac = [dbo].[NumerFaktury_Wyodrebnij](@cFaktura, 'M', @cFormat);
    
    SET @cNumer = [dbo].[NumerFaktury_Wyodrebnij](@cFaktura, 'N', @cFormat);

    SET @cIndeks = RIGHT('0000' + @cRok, 4) + 
                   RIGHT('00' + @cMiesiac, 2) +
                   RIGHT('00000' + @cNumer, 5);

    RETURN @cIndeks;
END;